﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Keyboard.Sample9
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern void keybd_event(Keys bVk, byte bScan, uint dwFlags, UIntPtr dwExtraInfo);

        public const uint KeyEvent_ExtendedKey = 0x01;
        public const uint KeyEvent_KeyUp = 0x02;
        public const uint KeyEvent_KeyDown = 0x0;

        public FormMain()
        {
            InitializeComponent();
        }

        readonly Keys[] numberKeys = new Keys[] { Keys.D0, Keys.D1, Keys.D2, Keys.D3, Keys.D4, Keys.D5, Keys.D6, Keys.D7, Keys.D8, Keys.D9 };

        private static void PressKey(Keys key)
        {
            keybd_event(key, 0x45, KeyEvent_ExtendedKey | KeyEvent_KeyDown, UIntPtr.Zero);
            keybd_event(key, 0x45, KeyEvent_ExtendedKey | KeyEvent_KeyUp, UIntPtr.Zero);
        }

        private static void PressKeyArray(Keys[] keys)
        {
            foreach (Keys key in keys)
            {
                PressKey(key);
            }
        }

        private void TimerKeyboardTick(object sender, EventArgs e)
        {
            PressKeyArray(numberKeys);
            Application.DoEvents();
        }

        public void MyKeyPress(Keys key)
        {
            keybd_event(key, 0, KeyEvent_KeyDown, UIntPtr.Zero);
            keybd_event(key, 0, KeyEvent_KeyUp, UIntPtr.Zero);
        }

        private void FormMain_Load(object sender, EventArgs e)
        {
            timerKeyboard.Interval = 1000;
            timerKeyboard.Start();
        }
    }
}